<?php get_header(); ?>
<div class="main-contaier">
    <div class="container">
    <?php
        while ( have_posts() ) {
            the_post();
            $sticky_class = ( is_sticky() ) ? 'zobo-post-sticky' : null;
            $featured_image = null;
            if ( has_post_thumbnail() ) {
                $featured_image = zobo_resize_image( get_post_thumbnail_id(), null, 1530, 700, true, true );
                $featured_image = $featured_image['url'];
            } ?>
        <div class="zobo-single-post">
            <div <?php post_class("{$sticky_class} item-blog"); ?>>
                <div class="inf-ath">
                    <?php echo get_avatar( get_the_author_meta( 'ID' ), 100 ); ?>
                    <div class="ath-name">
                        <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a>
                    </div>
                </div>      
                <h1 class="post-title title-single"><?php the_title(); ?></h1>
                <?php get_template_part('template-parts/post', 'meta'); ?>
                <?php if( $featured_image ) { ?>
                <div class="post-format">
                    <img src="<?php echo esc_url($featured_image); ?>" alt="<?php echo esc_attr__('Featured Image', 'zobo'); ?>" />
                </div>
                <?php } ?>
                <div class="post-info">
                    <div class="row justify-content-md-center">
                        <div class="col-md-8 col-xl-9">
                            <div class="post-content">
                                <?php
                                    the_content();
                                    wp_link_pages(
                                        array(
                                            'before'   => '<p class="page-nav">' . esc_html__( 'Pages:', 'zobo' ),
                                            'after'    => '</p>'
                                        )
                                    );
                                ?>
                            </div><?php
                            if ( get_the_tags() || function_exists('zobo_post_share') ) {
                                $tags_class = null;
                                if ( !get_the_tags() ) {
                                    $tags_class = 'tags-center';
                                }

                                if ( !function_exists('zobo_post_share') ) {
                                    $tags_class = 'tags-center';
                                } ?>
                            <div class="post-bottom <?php echo esc_attr($tags_class); ?>">
                                <?php if ( get_the_tags() ) { ?>
                                <div class="post-tags">
                                    <?php the_tags(esc_html__('Tags: ', 'zobo'), ', '); ?>
                                </div>
                                <?php } ?>
                                 <?php if ( function_exists('zobo_post_share') ) { ?>
                                <div class="post-social"><?php echo zobo_post_share(); ?></div>
                                <?php } ?>
                            </div>
                            <?php } ?>                            
                            <?php get_template_part( 'template-parts/single', 'post-related' ); ?>
                             <?php
                                if ( comments_open() || get_comments_number() ) :
                                    comments_template('', true);
                                endif;
                            ?>                            
                        </div>
                        <?php if ( ! get_theme_mod( 'zobo_single_post_hide_sidebar' ) ) { ?>
                        <div class="col-md-4 col-xl-3">
                            <?php get_sidebar(); ?>
                        </div>
                        <?php } ?>
                    </div>                  
                </div>
            </div>
        </div>
    <?php } ?>
    
    </div>
</div>
<?php get_footer(); ?>
