<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <header id="zobo-header" class="header">
        <div class="container">        
            <div class="header-content d-table">
                <div class="zobo-logo d-table-cell"> 
                    <?php if ( is_front_page() ) { ?>
                    <h1>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if ( get_theme_mod('zobo_logo_url') ) { ?>
                            <img src="<?php echo esc_url( get_theme_mod('zobo_logo_url') ); ?>" alt="<?php bloginfo( 'name' ); ?>" />
                            <?php } else { ?>
                            <span class="text-logo"><?php echo bloginfo('name'); ?></span>
                            <?php } ?>
                        </a>
                    </h1>
                    <?php  } else { ?>
                    <h2>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if ( get_theme_mod('zobo_logo_url') ) { ?>
                            <img src="<?php echo esc_url( get_theme_mod('zobo_logo_url') ); ?>" alt="<?php bloginfo( 'name' ); ?>" />
                            <?php } else { ?>
                            <span class="text-logo"><?php echo bloginfo('name'); ?></span>
                            <?php } ?>
                        </a>
                    </h2>
                    <?php } ?>
                </div>
                <div class="zobo-mainmenu d-table-cell">
                    <div id="nav-wrapper" class="nav-main">
                        <?php
                            wp_nav_menu( array (
                                'container' => false,
                                'theme_location' => 'primary',
                                'fallback_cb' => 'wp_bootstrap_navwalker::fallback',
                                'menu_class' => 'main-menu',
                                'depth' => 10,
                                'walker' => new wp_bootstrap_navwalker()
                            ) );
                        ?>
                    </div>
                    <a href="javascript:void(0)" class="nav-icon toggle-mainmenu">
                        <i class="fas fa-bars"></i>
                    </a>
                </div>
                <div class="header-social zobo-social d-table-cell">
                    <?php if(get_theme_mod('zobo_facebook_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_facebook_url') ); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a><?php endif; ?>
                    <?php if(get_theme_mod('zobo_twitter_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_twitter_url') ); ?>" target="_blank"><i class="fab fa-twitter"></i></a><?php endif; ?>
                    <?php if(get_theme_mod('zobo_instagram_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_instagram_url') ); ?>" target="_blank"><i class="fab fa-instagram"></i></a><?php endif; ?>
                    <?php if(get_theme_mod('zobo_pinterest_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_pinterest_url') ); ?>" target="_blank"><i class="fab fa-pinterest-p"></i></a><?php endif; ?>
                    <?php if(get_theme_mod('zobo_google_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_google_url') ); ?>" target="_blank"><i class="fab fa-google-plus-g"></i></a><?php endif; ?>
                    <?php if(get_theme_mod('zobo_youtube_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_youtube_url') ); ?>" target="_blank"><i class="fab fa-youtube"></i></a><?php endif; ?>
                    <?php if(get_theme_mod('zobo_vimeo_url')) : ?><a href="<?php echo esc_url( get_theme_mod('zobo_vimeo_url') ); ?>" target="_blank"><i class="fab fa-vimeo-square"></i></a><?php endif; ?>
                    <?php if ( function_exists('wc_get_cart_url') ) { ?>
                    <a class="cart-customlocation" href="<?php echo wc_get_cart_url(); ?>" title="<?php echo esc_attr__('View your shopping cart', 'zobo'); ?>">
                        <i class="fas fa-shopping-cart"></i>
                        <span><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                    </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </header>
    <div class="zobo-primary">
    