<?php
# Define
define('ZOBO_LIBS_URI', get_template_directory_uri() . '/libs/');
define('ZOBO_CORE_PATH', get_template_directory() . '/core/');
define('ZOBO_CORE_URI', get_template_directory_uri() . '/core/');
define('ZOBO_CORE_CLASSES', ZOBO_CORE_PATH . 'classes/');
define('ZOBO_CORE_FUNCTIONS', ZOBO_CORE_PATH . 'functions/');
define('ZOBO_CORE_WIDGETS', ZOBO_CORE_PATH . 'widgets/');

# Set Content Width
if ( ! isset( $content_width ) ) { $content_width = 1530; }

# After setup theme
add_action('after_setup_theme', 'zobo_setup');
function zobo_setup()
{
    load_theme_textdomain('zobo', get_template_directory().'/languages');
	add_theme_support('automatic-feed-links');
	add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
	register_nav_menus(array('primary' => esc_html__('Main Menu', 'zobo')));
	add_theme_support('post-formats', array( 'image', 'video', 'audio', 'gallery'));
    add_theme_support('align-wide');
    add_theme_support('align-full');
    $args = array('default-color' => '#ffffff', 'default-image' => null);
    add_theme_support('custom-background', $args );
    add_theme_support('woocommerce');    
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');    
    add_theme_support('editor-styles');
    add_editor_style('style-editor.css');

}

add_filter ( 'woocommerce_product_thumbnails_columns', 'zobo_change_gallery_columns' );
function zobo_change_gallery_columns() {
     return 5; 
}

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4, 0 );

add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
	return array(
		'width'  => 150,
		'height' => 150,
		'crop'   => 1,
	);
} );

# Google Fonts
add_action( 'wp_enqueue_scripts', 'zobo_enqueue_googlefonts' );
function zobo_enqueue_googlefonts()
{
    $fonts_url = '';
    $Roboto = _x( 'on', 'Roboto font: on or off', 'zobo' );
    $Open_Sans = _x( 'on', 'Open Sans font: on or off', 'zobo' );
    if( 'off' != $Roboto || 'off' != $Open_Sans )
    {
        $font_families = array();
        if ( 'off' !== $Roboto ) $font_families[] = 'Roboto:400,500';
        if ( 'off' !== $Open_Sans ) $font_families[] = 'Open Sans:400,600';
        $query_args = array('family' => urlencode(implode('|', $font_families)), 'subset' => urlencode('latin,latin-ext'));
        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    wp_enqueue_style('zobo-googlefonts', esc_url_raw($fonts_url), array(), null);
}

add_action( 'enqueue_block_editor_assets', 'zobo_enqueue_googlefonts' );

# Enqueue Scripts
add_action( 'wp_enqueue_scripts', 'zobo_load_scripts' );
function zobo_load_scripts()
{
    # CSS
    wp_enqueue_style('bootstrap', ZOBO_LIBS_URI . 'bootstrap/bootstrap.css');
    wp_enqueue_style('font-awesome', ZOBO_LIBS_URI . 'font-awesome/css/all.css');
    wp_enqueue_style('chosen', ZOBO_LIBS_URI . 'chosen/chosen.css');
    wp_enqueue_style('owl-carousel', ZOBO_LIBS_URI . 'owl/owl.carousel.css');
    wp_enqueue_style('zobo-style', get_stylesheet_directory_uri() . '/style.css');

    # JS
	wp_enqueue_script('fitvids', ZOBO_LIBS_URI . 'fitvids/fitvids.js', array(), false, true);
    wp_enqueue_script('owl-carousel', ZOBO_LIBS_URI . 'owl/owl.carousel.js', array(), false, true);
    wp_enqueue_script('chosen', ZOBO_LIBS_URI . 'chosen/chosen.js', array(), false, true);
    wp_enqueue_script('imagesloaded');
    wp_enqueue_script('isotope-pkgd', ZOBO_LIBS_URI . 'isotope/isotope.pkgd.js', array(), false, true);
    wp_enqueue_script('zobo-blog-masonry', get_template_directory_uri() . '/assets/js/zobo-blog-masonry.js', array(), false, true);
    wp_enqueue_script('zobo-scripts', get_template_directory_uri() . '/assets/js/zobo-scripts.js', array(), false, true);
    
    if ( is_singular() && get_option('thread_comments') ) {
        wp_enqueue_script('comment-reply');
    }
}

/**
 * @author AZ-Theme
 * @param int $attachment_id
 * @param string $attachment_url
 * @param int $width
 * @param int $height
 * @param bool $crop
 * @param bool $place_hold  Using place hold image if the image does not exist
 * @since 1.0
 * @return url or false
 */
function aztheme_resize_image( $attachment_id = null, $attachment_url = null, $width, $height, $crop = false, $place_holder = false )
{
    $actual_file_path = null;
    if ( $attachment_id ) {
        $actual_file_path = get_attached_file( $attachment_id );
    } elseif ( $attachment_url ) {
  		$actual_file_path = str_replace( get_site_url(), rtrim( ABSPATH, '/' ), $attachment_url );
    }
    
    if ( !$actual_file_path && $place_holder ) {
        $actual_file_path = get_template_directory() . '/assets/images/place-holder.png';
    }

    if ( $actual_file_path )
    {
        $image_editor = wp_get_image_editor( $actual_file_path );    
        if ( ! is_wp_error($image_editor) ) {
            $image_editor->resize( $width, $height, $crop );
            $new_image = $image_editor->save( $image_editor->generate_filename() );
            $new_image_url = str_replace( rtrim( ABSPATH, '/' ), get_site_url(), $new_image['path'] );
            return $new_image_url;     
        }
    }
    return false;
}
# Register Sidebar
add_action( 'widgets_init', 'zobo_widgets_init' );
function zobo_widgets_init() {
    register_sidebar(array(
		'name'            => esc_html__('Sidebar', 'zobo'),
		'id'              => 'sidebar',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('Page Sidebar', 'zobo'),
		'id'              => 'page-sidebar',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('About Me', 'zobo'),
		'id'              => 'about-me',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('Footer Instagram', 'zobo'),
		'id'              => 'footer-ins',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>',
        'description' => esc_html__('Display Instagram photos', 'zobo')
	));
    register_sidebar(array(
		'name'            => esc_html__('Footer column 1', 'zobo'),
		'id'              => 'footer-column-1',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('Footer column 2', 'zobo'),
		'id'              => 'footer-column-2',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('Footer column 3', 'zobo'),
		'id'              => 'footer-column-3',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
    register_sidebar(array(
		'name'            => esc_html__('Footer column 4', 'zobo'),
		'id'              => 'footer-column-4',
		'before_widget'   => '<div id="%1$s" class="widget %2$s">',
		'after_widget'    => '</div>',
		'before_title'    => '<h4 class="widget-title">',
		'after_title'     => '</h4>'
	));
}

# Check file exists
function zobo_require_file( $path ) {
    if ( file_exists($path) ) {
        require $path;
    }
}

# Require file
zobo_require_file( get_template_directory() . '/core/init.php' );

# Blog configs
function zobo_blog_configs()
{
    if ( is_archive() || is_search() ) {
        $zobo_blog_layout = get_theme_mod('zobo_archive_layout', '3cols_grid');
        $zobo_blog_hide_sidebar = get_theme_mod('zobo_archive_hide_sidebar');
    } else {
        $zobo_blog_layout = get_theme_mod('zobo_blog_layout', '4cols_masonry');
        if ( isset($_REQUEST['layout']) && trim($_REQUEST['layout']) != '' ) {
            $zobo_blog_layout = trim($_REQUEST['layout']);
        }
        $zobo_blog_hide_sidebar = get_theme_mod('zobo_blog_hide_sidebar');
    }
    
    if ( isset($_REQUEST['sidebar']) ) {
        $zobo_blog_hide_sidebar = $_REQUEST['sidebar'] == 'no' ? true : false; 
    }
    
    if ( $zobo_blog_layout == '4cols_grid' || $zobo_blog_layout == '4cols_mix_3cols' || $zobo_blog_layout == '4cols_masonry' ) {
        $zobo_blog_hide_sidebar = true;
    }
    
    $zobo_blog = array();
    $zobo_blog['layout'] = $zobo_blog_layout;
    $zobo_blog['hide_sidebar'] = $zobo_blog_hide_sidebar;
    return $zobo_blog;
}

# Limit Blog Posts
function zobo_posts_per_page( $posts_per_page ) {    
    
    if ( isset($_REQUEST['limit']) && trim($_REQUEST['limit']) != '' ) {
        return $_REQUEST['limit'];
    }
    
    if ( get_theme_mod('zobo_blog_posts_per_page') && is_home() ) {
        return get_theme_mod('zobo_blog_posts_per_page');
    }
    
    return $posts_per_page;
}

if ( !is_admin() ) {
    add_filter('pre_option_posts_per_page', 'zobo_posts_per_page');
}

# Limit Archive Posts
add_filter('pre_get_posts', 'zobo_limit_archive_posts');
function zobo_limit_archive_posts($query) {
    $is_woo = false;
    if ( ( function_exists( 'is_shop' ) && is_shop() ) || ( function_exists( 'is_product_taxonomy' ) && is_product_taxonomy() ) ) {
        $is_woo = true;
    }
    
    if ( is_archive() && !$is_woo ) {
        $query->set('posts_per_page', get_theme_mod('zobo_archive_posts_per_page', 9));
    }
    return $query;
}

//Exclude pages from WordPress Search
if ( !is_admin() ) {
    function zobo_search_filter($query) {
        if ($query->is_search) {
            $query->set('post_type', 'post');
        }
        return $query;
    }
    add_filter('pre_get_posts','zobo_search_filter');
}

# Comment Layout
function zobo_custom_comment($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
	<<?php echo esc_attr($tag); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
		<div class="comment-author">
		<?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
		</div>
		<div class="comment-content">
		    <h4 class="author-name"><?php echo get_comment_author_link(); ?></h4>
			<div class="date-comment">
				<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
				<?php printf( esc_html__('%1$s at %2$s', 'zobo'), get_comment_date(),  get_comment_time() ); ?></a>
			</div>
			<div class="reply">
				<?php edit_comment_link( esc_html__( '(Edit)', 'zobo' ), '  ', '' );?>
				<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div>
			<?php if ( $comment->comment_approved == '0' ) : ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'zobo' ); ?></em>
				<br />
			<?php endif; ?>
			<div class="comment-text"><?php comment_text(); ?></div>
		</div>	
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
<?php
}

# Pagination
function zobo_pagination()
{
    global $wp_query;
    if ( (int)$wp_query->found_posts > (int)get_option('posts_per_page') ) : ?>
    <div class="zobo-pagination"><?php
        $args = array(
            'prev_text' => '<span class="fa fa-angle-left"></span>',
            'next_text' => '<span class="fa fa-angle-right"></span>'
        );
        the_posts_pagination($args);
    ?>
    </div>
    <?php
    endif;
}

# The Excerpt
function zobo_excerpt_length($length)
{
    if ( is_admin() ) {
        return $length;
    }

    if ( get_theme_mod('zoboe_custom_excerpt', true) ) {
        return get_theme_mod('zobo_custom_excerpt_length', 25);
    }
}
add_filter( 'excerpt_length', 'zobo_excerpt_length', 999 );

/**
 * Custom Excerpt Length
 */
function zobo_custom_excerpt_more( $more ) {
    return '...';
}
add_filter( 'excerpt_more', 'zobo_custom_excerpt_more' );

/**
 * Show cart contents / total Ajax
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	?>
	<a class="cart-customlocation" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php echo esc_attr__('View your shopping cart', 'zobo'); ?>">
        <i class="fas fa-shopping-cart"></i>
        <span><?php echo WC()->cart->get_cart_contents_count(); ?></span>
    </a><?php
    $fragments['a.cart-customlocation'] = ob_get_clean();
	return $fragments;
}

# Demo Import
function zobo_import_files()
{
  return array(
    array(
      'import_file_name'           => esc_html__('Demo Import', 'zobo'),
      'categories'                 => array(),
      'import_file_url'            => get_template_directory_uri() . '/core/demo-import/content.xml',
      'import_widget_file_url'     => get_template_directory_uri() . '/core/demo-import/widgets.json',
      'import_customizer_file_url' => get_template_directory_uri() . '/core/demo-import/customizer.dat',
      'import_redux'               => array(),
      'import_preview_image_url'   => '',
      'import_notice'              => esc_html__('After importing demo data you need to set up menu for your site!', 'zobo'),
      'preview_url'                => esc_url('http://zobo.theme-xoda.net')
    )
  );
}
add_filter( 'pt-ocdi/import_files', 'zobo_import_files' );

# Include the TGM_Plugin_Activation class
add_action('tgmpa_register', 'zobo_register_required_plugins');
function zobo_register_required_plugins()
{
	$plugins = array(
        array(
			'name'      => esc_html__('Zobo Helper', 'zobo'),
			'slug'     	=> 'zobo-helper',
            'source'   	=> get_template_directory() . '/plugins/zobo-helper.zip'
		),
        array(
			'name'     	=> esc_html__('WP Instagram Widget', 'zobo'),
			'slug'     	=> 'wp-instagram-widget'
		),
        array(
			'name'     	=> esc_html__('Categories Images', 'zobo'),
			'slug'     	=> 'categories-images',
		),
        array(
			'name'     	=> esc_html__('WooCommerce', 'zobo'),
			'slug'     	=> 'woocommerce'
        ),
		array(
			'name'     	=> esc_html__('Contact Form 7', 'zobo'),
			'slug'     	=> 'contact-form-7'
		),
        array(
			'name'     	=> esc_html__('MailChimp for WordPress', 'zobo'),
			'slug'     	=> 'mailchimp-for-wp'
		),
        array(
			'name'     	=> esc_html__('One Click Demo Import', 'zobo'),
			'slug'     	=> 'one-click-demo-import'
		)
	);

	$config = array(
		'id'           => 'zobo',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => true,
		'message'      => ''
	);
	tgmpa($plugins, $config);
}
