<?php
function zobo_sanitize_default($value) {return $value;}

/** Customizer - Add Settings */
function zobo_register_theme_customizer( $wp_customize )
{
    # Theme Options
    $wp_customize->add_panel('zobo_panel', array('priority' => 1, 'capability'=> 'edit_theme_options', 'title' => esc_html__('ZOBO: Theme Options', 'zobo') ));
    
	# Sections
    $wp_customize->add_section( 'zobo_section_blog_settings', array( 'title' => esc_html__('Blog', 'zobo'), 'panel' => 'zobo_panel' ) );
    $wp_customize->add_section( 'zobo_section_post', array( 'title' => esc_html__( 'Post', 'zobo' ), 'panel' => 'zobo_panel' ) );
    $wp_customize->add_section( 'zobo_section_page', array( 'title' => esc_html__( 'Page', 'zobo' ), 'panel' => 'zobo_panel' ) );
    $wp_customize->add_section( 'zobo_section_featured_posts', array( 'title' => esc_html__('Featured Posts Slider', 'zobo'), 'panel' => 'zobo_panel' ) );
    $wp_customize->add_section( 'zobo_section_social_media', array( 'title' => esc_html__('Social Media', 'zobo'), 'panel' => 'zobo_panel' ) );
    $wp_customize->add_section( 'zobo_new_section_instagram', array( 'title' => esc_html__('Instagram Feed', 'zobo'), 'panel' => 'zobo_panel' ) );
    $wp_customize->add_section( 'zobo_section_footer', array('title' => esc_html__('Footer', 'zobo'), 'panel' => 'zobo_panel' ));
    
    /** Logo */
    $wp_customize->add_setting( 'zobo_logo_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default' ));
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize, 'zobo_logo_url',
            array(
                'label' => esc_html__('Site Logo', 'zobo'),
                'section' => 'title_tagline',
                'priority' => 2
            )
        )
    );

    /** Blog */
    $wp_customize->add_setting('zobo_blog_layout', array('default' => '4cols_masonry', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_archive_layout', array('default' => '3cols_grid', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_blog_hide_sidebar', array('default' => false, 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_archive_hide_sidebar', array('default' => false, 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_hide_sidebar_archive', array('default' => false, 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_blog_posts_per_page', array('default' => 12, 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_archive_posts_per_page', array('default' => 9, 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'zobo_blog_layout',
            array(
                'label'     => esc_html__( 'Blog Layout', 'zobo' ),
                'section'   => 'zobo_section_blog_settings',
                'type'      => 'radio',
                'choices'   => array(
                    '4cols_grid' => esc_html__( '4 Cols Grid', 'zobo' ),
                    '3cols_grid' => esc_html__( '3 Cols Grid', 'zobo' ),
                    '2cols_grid' => esc_html__( '2 Cols Grid', 'zobo' ),
                    '4cols_mix_3cols' => esc_html__( '4 Mix 3 Cols', 'zobo' ),
                    '3cols_mix_2cols' => esc_html__( '3 Mix 2 Cols', 'zobo' ),
                    '4cols_masonry' => esc_html__( '4 Cols Masonry', 'zobo' ),
                    '3cols_masonry' => esc_html__( '3 Cols Masonry', 'zobo' )
                )
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'zobo_archive_layout',
            array(
                'label'     => esc_html__( 'Archive Layout', 'zobo' ),
                'section'   => 'zobo_section_blog_settings',
                'type'      => 'radio',
                'choices'   => array(
                    '4cols_grid' => esc_html__( '4 Cols Grid', 'zobo' ),
                    '3cols_grid' => esc_html__( '3 Cols Grid', 'zobo' ),
                    '2cols_grid' => esc_html__( '2 Cols Grid', 'zobo' ),
                    '4cols_mix_3cols' => esc_html__( '4 Mix 3 Cols', 'zobo' ),
                    '3cols_mix_2cols' => esc_html__( '3 Mix 2 Cols', 'zobo' ),
                    '4cols_masonry' => esc_html__( '4 Cols Masonry', 'zobo' ),
                    '3cols_masonry' => esc_html__( '3 Cols Masonry', 'zobo' )
                )
            )
        )
    );
    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_blog_hide_sidebar',
			array(
				'label' => esc_html__('Hide sidebar on Blog?', 'zobo'),
				'section' => 'zobo_section_blog_settings',
                'type' => 'checkbox'
			)
		)
	);
    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_archive_hide_sidebar',
			array(
				'label' => esc_html__('Hide sidebar on Archive?', 'zobo'),
				'section' => 'zobo_section_blog_settings',
                'type' => 'checkbox'
			)
		)
	);
    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_blog_posts_per_page',
			array(
				'label' => esc_html__('Blog Posts Per Page', 'zobo'),
				'section' => 'zobo_section_blog_settings',
                'type' => 'number'
			)
		)
	);
    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_archive_posts_per_page',
			array(
				'label' => esc_html__('Archive Posts Per Page', 'zobo'),
				'section' => 'zobo_section_blog_settings',
                'type' => 'number'
			)
		)
	);

    /** Post Excerpt **/
    $wp_customize->add_setting( 'zobo_single_post_hide_sidebar', array( 'default' => false, 'sanitize_callback' => 'zobo_sanitize_default' ) );
    $wp_customize->add_setting( 'zobo_custom_excerpt', array( 'default' => true, 'sanitize_callback' => 'zobo_sanitize_default' ) );
    $wp_customize->add_setting( 'zobo_custom_excerpt_length', array( 'default' => '25', 'sanitize_callback' => 'zobo_sanitize_default' ) );

    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_single_post_hide_sidebar',
			array(
				'label' => esc_html__('Hide sidebar on Single Post?', 'zobo'),
				'section' => 'zobo_section_post',
                'type' => 'checkbox'
			)
		)
	);
    $wp_customize->add_control(
	    new WP_Customize_Control(
	        $wp_customize,
	        'zobo_custom_excerpt',
	            array(
	                'label' => esc_html__( 'Custom excerpt?', 'zobo' ),
	                'section' => 'zobo_section_post',
                    'type' => 'checkbox'
	            )
	    )
	);

    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_custom_excerpt_length',
			array(
				'label'      => esc_html__('Excerpt length', 'zobo'),
				'section'    => 'zobo_section_post',
				'type'		 => 'number'
			)
		)
	);
    
    /** Post Excerpt **/
    $wp_customize->add_setting( 'zobo_page_sidebar', array( 'default' => false, 'sanitize_callback' => 'zobo_sanitize_default' ) );

    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_page_sidebar',
			array(
				'label' => esc_html__('Display Sidebar on Page?', 'zobo'),
				'section' => 'zobo_section_page',
                'type' => 'checkbox'
			)
		)
	);

    /** Featured Posts Slider */
    $wp_customize->add_setting( 'zobo_featured_posts_enable', array( 'sanitize_callback' => 'zobo_sanitize_default' ) );
	$wp_customize->add_setting( 'zobo_featured_posts_catid', array( 'sanitize_callback' => 'zobo_sanitize_default' ) );
	$wp_customize->add_setting( 'zobo_featured_posts_ids', array( 'sanitize_callback' => 'zobo_sanitize_default' ) );
	$wp_customize->add_setting( 'zobo_featured_posts_limit', array( 'default' => '3', 'sanitize_callback' => 'zobo_sanitize_default' ) );
    
    $wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_featured_posts_enable',
			array(
				'label' => esc_html__('Enable Featured Posts Slider?', 'zobo'),
				'section' => 'zobo_section_featured_posts',
				'type' => 'checkbox'
			)
		)
	);
    
	$wp_customize->add_control(
		new WP_Customize_Category_Control(
			$wp_customize,
			'zobo_featured_posts_catid',
			array(
				'label' => esc_html__('Select Category', 'zobo'),
				'section' => 'zobo_section_featured_posts'
			)
		)
	);	
	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'zobo_featured_posts_ids',
			array(
				'label' => esc_html__('Select featured post/page IDs', 'zobo'),
				'section' => 'zobo_section_featured_posts',
				'type' => 'text'
			)
		)
	);
	
	$wp_customize->add_control(
		new Customize_Number_Control(
			$wp_customize,
			'zobo_featured_posts_limit',
			array(
				'label' => esc_html__('Amount of Slides', 'zobo'),
				'section' => 'zobo_section_featured_posts',
				'type' => 'number'
			)
		)
	);

    /** Social Media */
    $wp_customize->add_setting('zobo_facebook_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_twitter_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_instagram_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_pinterest_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_google_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_youtube_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default')); 
    $wp_customize->add_setting('zobo_vimeo_url', array('default' => '', 'sanitize_callback' => 'zobo_sanitize_default'));
    
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_facebook_url', array('label' => esc_html__('Facebook URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings' => 'zobo_facebook_url', 'type' => 'text', 'priority' => 1)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_twitter_url', array('label' => esc_html__('Twitter URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings' => 'zobo_twitter_url', 'type' => 'text', 'priority' => 2)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_instagram_url', array('label' => esc_html__('Instagram URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings' => 'zobo_instagram_url', 'type' => 'text', 'priority' => 3)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_pinterest_url', array('label' => esc_html__('Pinterest URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings' => 'zobo_pinterest_url', 'type' => 'text', 'priority' => 4)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_google_url', array('label' => esc_html__('Google Plus URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings' => 'zobo_google_url', 'type' => 'text', 'priority' => 5)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_youtube_url', array('label' => esc_html__('Youtube URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings'  => 'zobo_youtube_url', 'type' => 'text', 'priority' => 6)));
	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'zobo_vimeo_url', array('label' => esc_html__('Vimeo URL', 'zobo'), 'section' => 'zobo_section_social_media', 'settings' => 'zobo_vimeo_url', 'type' => 'text', 'priority' => 7)));
    
    /**
     * Instagram Feed
     */
    $wp_customize->add_setting( 'aztheme_instagram_show', array( 'default' => false, 'sanitize_callback' => 'zobo_sanitize_default' ) );
    $wp_customize->add_setting( 'aztheme_instagram_access_token', array( 'default' => null, 'sanitize_callback' => 'zobo_sanitize_default' ) );
    $wp_customize->add_setting( 'aztheme_instagram_access_token_link', array( 'default' => null, 'sanitize_callback' => 'zobo_sanitize_default' ) );
    $wp_customize->add_control(
    	new WP_Customize_Control(
    		$wp_customize,
    		'aztheme_instagram_show',
    		array(
    			'label'      => esc_html__('Show Instagram Feed', 'zobo'),
    			'section'    => 'zobo_new_section_instagram',
    			'type'		 => 'checkbox'
    		)
    	)
    );
    $wp_customize->add_control(
    	new WP_Customize_Control(
    		$wp_customize,
    		'aztheme_instagram_access_token',
    		array(
    			'label'      => esc_html__('Instagram Access Token*', 'zobo'),
    			'section'    => 'zobo_new_section_instagram',
    			'type'		 => 'text',
    			'description' => esc_html__('An access token provides a secure way for a website to ask Instagram to display the images. ', 'zobo')
    		)
    	)
    );
    $wp_customize->add_control(
    	new Info_Custom_control(
    		$wp_customize,
    		'aztheme_instagram_access_token_link',
    		array(
    			'label'      => esc_html__('Get Access Token', 'zobo'),
    			'section'    => 'zobo_new_section_instagram'
    		)
    	)
    );

    /** Footer */
    $wp_customize->add_setting( 'zobo_footer_copyright_text', array( 'default' => esc_html__('2019 - Zobo. All Rights Reserved. Designed & Developed by AZ-Theme', 'zobo'), 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'footer_copyright', array('label' => esc_html__('Copyright Text', 'zobo'), 'section' => 'zobo_section_footer', 'settings' => 'zobo_footer_copyright_text', 'type' => 'text')));
    
    /** Colors */
    $wp_customize->add_setting('zobo_body_color', array('default' => esc_attr('#454545'), 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_setting('zobo_accent_color', array('default' => esc_attr('#c67474'), 'sanitize_callback' => 'zobo_sanitize_default'));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'zobo_body_color', array('label' => esc_html__('Body Text Color', 'zobo'), 'section' => 'colors', 'settings' => 'zobo_body_color')));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'zobo_accent_color', array('label' => esc_html__('Accent Color', 'zobo'), 'section' => 'colors', 'settings' => 'zobo_accent_color')));
}
add_action( 'customize_register', 'zobo_register_theme_customizer' );
