<?php
    get_header();
    $zobo_archive_layout = get_theme_mod('zobo_archive_layout');
    $col = get_theme_mod('zobo_archive_hide_sidebar') ? 'col-md-12' : 'col-md-8 col-lg-8 col-xl-9';
?>
<div class="main-contaier">
    <div class="container">
        <div class="archive-box main-blog">
            <?php if ( is_category() ) : ?>
                <h1><span><?php echo esc_html__( 'Category', 'zobo' ); ?>:</span> <?php printf( esc_html__('%s', 'zobo'), single_cat_title('', false) ); ?></h1>
                <div class="desc-cat"><?php echo category_description(); ?></div>
            <?php elseif ( is_tag() ) : ?>
                <h1><span><?php echo esc_html__( 'Tag', 'zobo' ); ?>:</span> <?php printf(esc_html__('%s', 'zobo'), single_tag_title('', false)); ?></h1>
            <?php elseif ( is_author() ) : ?>
                <h1><span><?php echo esc_html__( 'Author', 'zobo' ); ?>:</span> <?php the_post(); echo get_the_author(); ?></h1>
            <?php else : ?>
                <?php if ( is_day() ) : ?>
                    <h1><span><?php echo esc_html__( 'Day', 'zobo' ); ?>:</span> <?php echo get_the_date(); ?></h1>
                <?php elseif ( is_month() ) : ?>
                    <h1><span><?php echo esc_html__( 'Month', 'zobo' ); ?>:</span> <?php echo get_the_date( _x( 'F Y', 'monthly archives date format', 'zobo' ) ); ?></h1>
                <?php elseif ( is_year() ) : ?>
                    <h1><span><?php echo esc_html__( 'Year', 'zobo' ); ?>:</span> <?php echo get_the_date( _x( 'Y', 'yearly archives date format', 'zobo' ) ); ?></h1>
                <?php else : ?>
                    <h1><?php esc_html_e('Archives', 'zobo'); ?></h1>
                <?php endif; ?>
            <?php endif; ?>
        </div>    
        <div class="row">
            <div class="<?php echo esc_attr( $col ); ?>">
            <?php
                if ( $zobo_archive_layout == '4cols_grid' )
                {
                    get_template_part( 'loop/blog', '4cols-grid' );
                }
                elseif ( $zobo_archive_layout == '2cols_grid' )
                {
                    get_template_part( 'loop/blog', '2cols-grid' );
                }
                elseif ( $zobo_archive_layout == '4cols_mix_3cols' )
                {
                    get_template_part( 'loop/blog', '4cols-mix-3cols' );
                }
                elseif ( $zobo_archive_layout == '3cols_mix_2cols' )
                {
                    get_template_part( 'loop/blog', '3cols-mix-2cols' );
                }
                elseif ( $zobo_archive_layout == '4cols_masonry' )
                {
                    get_template_part( 'loop/blog', '4cols-masonry' );
                }
                elseif ( $zobo_archive_layout == '3cols_masonry' )
                {
                    get_template_part( 'loop/blog', '3cols-masonry' );
                }
                else
                {
                    get_template_part( 'loop/blog', '3cols-grid' );
                }
            ?>
            </div>
            <?php if ( !get_theme_mod('zobo_archive_hide_sidebar') ) { ?>
            <div class="col-md-4 col-lg-4 col-xl-3">
                <?php if ( is_active_sidebar('sidebar') ) { ?>
				<aside id="sidebar" class="sidebar">
                    <?php dynamic_sidebar('sidebar'); ?>
                </aside>
                <?php } ?>
            </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php get_footer(); ?>