<?php
    get_header();
    $zobo_archive_layout = get_theme_mod('zobo_archive_layout');
    $col = get_theme_mod('zobo_archive_hide_sidebar') ? 'col-md-12' : 'col-md-8 col-lg-8 col-xl-9';
?>
<div class="main-contaier">
    <div class="container">
        <?php if ( have_posts() ) { ?> 
            <div class="archive-box main-blog">
                <h1><span><?php esc_html_e( 'Search results for', 'zobo' ); ?>:</span>&nbsp;<?php printf( esc_html__( '%s', 'zobo' ), get_search_query() ); ?></h1>
            </div>
            <div class="row">
                <div class="<?php echo esc_attr( $col ); ?>">
                <?php
                    if ( $zobo_archive_layout == '4cols_grid' )
                    {
                        get_template_part( 'loop/blog', '4cols-grid' );
                    }
                    elseif ( $zobo_archive_layout == '2cols_grid' )
                    {
                        get_template_part( 'loop/blog', '2cols-grid' );
                    }
                    elseif ( $zobo_archive_layout == '4cols_mix_3cols' )
                    {
                        get_template_part( 'loop/blog', '4cols-mix-3cols' );
                    }
                    elseif ( $zobo_archive_layout == '3cols_mix_2cols' )
                    {
                        get_template_part( 'loop/blog', '3cols-mix-2cols' );
                    }
                    elseif ( $zobo_archive_layout == '4cols_masonry' )
                    {
                        get_template_part( 'loop/blog', '4cols-masonry' );
                    }
                    elseif ( $zobo_archive_layout == '3cols_masonry' )
                    {
                        get_template_part( 'loop/blog', '3cols-masonry' );
                    }
                    else
                    {
                        get_template_part( 'loop/blog', '3cols-grid' );
                    }
                ?>
                </div>
                <?php if ( !get_theme_mod('zobo_archive_hide_sidebar') ) { ?>
                <div class="col-md-4 col-lg-4 col-xl-3">
                    <?php if ( is_active_sidebar('sidebar') ) { ?>
        			<aside id="sidebar" class="sidebar">
                        <?php dynamic_sidebar('sidebar'); ?>
                    </aside>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        <?php } else {
            get_template_part('template-parts/post', 'none');
        } ?>        
    </div>       
</div>
<?php get_footer(); ?>