(function($){
	"use strict";	
    $(document).ready(function() {

        if ($('body').length ) { $('body').fitVids(); }
        $('select').chosen();
        
        // Owl carousel
        init_carousel();

       // BOX MOBILE MENU
        $(document).on('click','.toggle-mainmenu',function(){
            $('.zobo-clone-wrap').addClass('open');
            return false;
        });

        // Sidebar Toggle
        $('.zobo-widgets-plus .plus').on('click',function(){
            $(this).parents().addClass('active');
        });
        $('.zobo-widgets-plus .close-bt').on('click',function(){
            $('.zobo-widgets-plus').removeClass('active');
        });

        //Nav toggle
        $('.toggle-mainmenu').on('click',function(){
            $(this).toggleClass('active');
            $('.nav-main').slideToggle(300);
        });

        //Search mobile
        $('.touch-search').on('click',function(){
            $(this).parents().find('.search-inner').slideToggle(500);
        });

        //SHOW SUBMENU
        if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
            // on Mobile
            $('.nav-main .menu-item-has-children > a').on('click',function(){
                var $li_current = $(this).closest('.menu-item-has-children'),
                    $li_parrent = $('.nav-main .menu-item-has-children');
                if ( $li_current.hasClass('show-submenu')) {
                    $li_current.removeClass('show-submenu');
                    var href = $(this).attr('href');
                    if ( $.trim( href ) == '' || $.trim( href ) == '#' ) {
                      $li_current.toggleClass('show-submenu');
                    }
                    else{
                      window.location = href;
                    }
                } else {
                    $li_parrent.removeClass('show-submenu');
                    $li_current.parents().each(function (){
                        if($(this).hasClass('menu-item-has-children')){
                            $(this).addClass('show-submenu');   
                        }
                        if($(this).hasClass('main-menu')){
                            return false;
                        }
                    })
                    $li_current.addClass('show-submenu');
                    return false;
                }
                e.preventDefault();
                e.stopPropagation();
            });
        }else {
            // on Desktop
            $('.nav-main .menu-item-has-children').hover(function(){
                $(this).addClass('show-submenu');
            }, function() {
                $(this).removeClass('show-submenu');
            });
        }
        
        
        $(".quantity-button").on("click", function() {
        	var $button = $(this);
        	var oldValue = $button.parent().find("input").val();
        
        	if ($button.text() == "+") {
        	  var newVal = parseInt(oldValue) + 1;
        	} else {
        		if (oldValue > 0) {
        			var newVal = parseInt(oldValue) - 1;
        		} else {
        			newVal = 0;
        		}
        	}
        	$button.parent().find("input").val(newVal);
            $button.parent().find("input").trigger("change");
        });
    
    
    });
    
    
    /* ---------------------------------------------
     Owl carousel
    --------------------------------------------- */
    function init_carousel()
    {
        $('.owl-carousel').each(function(){
            var config = $(this).data();
            config.navText = ['<i class="fa fa-angle-left"></i>','<i class="fa fa-angle-right"></i>'];
        
            var animateOut = $(this).data('animateout');
            var animateIn = $(this).data('animatein');
            if(typeof animateOut != 'undefined' ){
              config.animateOut = animateOut;
            }
            if(typeof animateIn != 'undefined' ){
              config.animateIn = animateIn;
            }
            
            config.smartSpeed = 1000;

            var owl = $(this);
            owl.owlCarousel(config);

        });
    }
    
})(jQuery);
