<?php
/**
 * Plugin Name: Zobo Helper
 * Plugin URI: http://az-theme.net
 * Description: Zobo Helper Plugin expands the functionality of the theme. Adds new icons, shortcodes and much more.
 * Version: 1.0.0
 * Author: AZ-Theme
 * Author URI: http://az-theme.net
 * Text Domain: zobo-helper
 */
# Widgets
include 'widgets/about_me.php';
include 'widgets/categories_images.php';
include 'widgets/instagram_feed.php';

# Enqueue Scripts
add_action( 'wp_enqueue_scripts', 'zobo_helper_load_scripts' );
function zobo_helper_load_scripts() {
    # JS
	wp_enqueue_script('zobo-helper', plugin_dir_url( __FILE__ ) . 'js/zobo-helper.js', array(), false, true);
    wp_localize_script( 'zobo-helper', 'Zobolikepost', array(
    	'ajaxurl' => esc_url( admin_url('admin-ajax.php') )
    ));
}

add_action('wp_ajax_zobo-like-post', 'zobo_like_post_ajax');
add_action('wp_ajax_nopriv_zobo-like-post', 'zobo_like_post_ajax');
function zobo_like_post_ajax()
{
    if ( isset ( $_POST['likes_id'] ) )
    {
        $post_id = str_replace('zobo-like-post-', '', $_POST['likes_id']);
        $post_id = (int)$post_id;        
        $love_count = get_post_meta($post_id, '_zobo_like_post', true);
        $love_count = (int)$love_count;
        
    	if ( !isset($_COOKIE['zobo_like_post_'. $post_id]) )
        {
    	   $love_count++;
           update_post_meta($post_id, '_zobo_like_post', $love_count);
           setcookie('zobo_like_post_'. $post_id, $post_id, time()*20, '/');
    	}
        
        if ( (int)$love_count < 1 ) {
            $love_count = null;
        }
        
        echo esc_attr($love_count);
    }
    exit;
}

function zobo_add_love()
{
	global $post;
    
	$post_id = (int)$post->ID;    
    $love_count = get_post_meta($post_id, '_zobo_like_post', true);
   
    if( !$love_count )
    {
        $love_count = 0;
        add_post_meta($post_id, '_zobo_like_post', $love_count, true);
    }
                    
	$class = 'zobo-like-post';
    $title = esc_html__('Like this', 'zobo-helper');
	if( isset($_COOKIE['zobo_like_post_'. $post_id]) ){
		$class = 'zobo-like-post liked';
		$title = esc_html__('You already liked this!', 'zobo-helper');
	}
    
    $love_count = $love_count == 0 ? null : $love_count;

	return '<a href="#" class="'. $class .'" id="zobo-like-post-'. $post_id .'" title="'. esc_attr($title) .'"><i class="far fa-heart"></i> '.$love_count.'</a>';
}

# Url Encode
function zobo_url_encode( $title ) {
    $title = html_entity_decode( $title );
    $title = urlencode( $title );
    return $title;
}

function zobo_post_share()
{
    global $post;
    ob_start();
    $pin_image = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) ); ?>
    <div class="social-share share-buttons">
        <?php if ( is_single() ) { ?>
        <a target="_blank" href="<?php echo esc_url( 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink() ); ?>">Facebook</a>
        <a target="_blank" href="<?php echo esc_url( 'https://twitter.com/home?status=Check%20out%20this%20article:%20' . zobo_url_encode( get_the_title() ) . '%20-%20' . urlencode( get_the_permalink() ) ); ?>">Twitter</a>                    			
        <a target="_blank" href="<?php echo esc_url( 'https://pinterest.com/pin/create/button/?url=' . get_the_permalink() . '&media=' . esc_url($pin_image) . '&description=' . get_the_title() ); ?>">Pinterest</a>
        <?php } else { ?>
        <a target="_blank" href="<?php echo esc_url( 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink() ); ?>"><i class="fab fa-facebook-f"></i></a>
        <a target="_blank" href="<?php echo esc_url( 'https://twitter.com/home?status=Check%20out%20this%20article:%20' . zobo_url_encode( get_the_title() ) . '%20-%20' . urlencode( get_the_permalink() ) ); ?>"><i class="fab fa-twitter"></i></a>                    			
        <a target="_blank" href="<?php echo esc_url( 'https://pinterest.com/pin/create/button/?url=' . get_the_permalink() . '&media=' . esc_url($pin_image) . '&description=' . get_the_title() ); ?>"><i class="fab fa-pinterest-p"></i></a>
        <?php } ?>
    </div><?php
    $output = ob_get_contents();
    ob_clean();
    return $output;    
}
