<?php
class AZTheme_Instagram_Feed extends WP_Widget
{
	public function __construct()
    {
		$widget_ops = array(
            'classname' => 'aztheme-instagram-feed',
            'description' => esc_html__( 'Display Instagram photos with this widget.', 'zobo' )
        );
		parent::__construct('aztheme-instagram-feed', esc_html__('AZTheme: Instagram Widget', 'zobo'), $widget_ops);
	}
    
    /**
     * Instagram Feed
     */
    function instagram_feed( $token = null, $count = 9 )
    {
        $count = absint($count);
        if ( $token )
        {
            $url = "https://api.instagram.com/v1/users/self/media/recent/?access_token={$token}&count=$count";
            $request = wp_remote_get( $url );
        	if ( is_wp_error( $request ) || empty( $request ) ) {
        		return new WP_Error( 'communicate', esc_html__( 'Unable to communicate with Instagram. This may be a temporary problem. Please try again soon.', 'zobo' ) );
        	}
            $body = wp_remote_retrieve_body( $request );        
            $body = json_decode($body, true);
            $data = isset($body['data']) ? $body['data'] : array();
            return $data;
        }
    }

	public function widget( $args, $instance ) {

		$title = empty( $instance['title'] ) ? '' : apply_filters( 'widget_title', $instance['title'] );
		$number = empty( $instance['number'] ) ? 9 : $instance['number'];
		$size = empty( $instance['size'] ) ? 'standard_resolution' : $instance['size'];
		$target = empty( $instance['target'] ) ? '_self' : $instance['target'];
		$link_text = empty( $instance['link'] ) ? '' : $instance['link'];
    
        $photos = $this->instagram_feed( get_theme_mod('aztheme_instagram_access_token'), $number );
        
        if ( !empty($photos) )
        {
            $instagram_username = isset($photos[0]['user']['username']) ? $photos[0]['user']['username'] : null;
            
            echo $args['before_widget'];

                if ( !empty($title) ) {
                    echo $args['before_title'] . wp_kses_post( $title ) . $args['after_title'];
                } ?>
                <ul class="photos clearfix">
                    <?php foreach( $photos as $item ) { ?>
                        <?php $image = isset( $item['images'][$size]['url'] ) ? $item['images'][$size]['url'] : null; ?>
                        <?php if ( $image ) { ?>
                        <li class="photo-item">
                            <a href="<?php echo esc_url($item['link']); ?>" target="<?php echo esc_attr($target); ?>">
                                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($item['caption']['text']); ?>" />
                            </a>
                        </li>
                        <?php } ?>
        			<?php } ?>
                </ul>
                <?php if ( '' !== $link_text ) { ?>
    			<p class="author-link">
                    <a href="<?php echo esc_url( '//instagram.com/' . $instagram_username ); ?>" target="<?php echo esc_attr( $target ); ?>">
                        <?php echo wp_kses_post( $link_text ); ?>
                    </a>
                </p>
        		<?php } ?>
    		<?php

            echo $args['after_widget'];
        }
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'title' => esc_html__( 'My Instagram', 'zobo' ),
			'size' => 'standard_resolution',
			'link' => esc_html__( 'Follow Me!', 'zobo' ),
			'number' => 6,
            'columns' => 6,
			'target' => '_self'
		) );
		$title    = $instance['title'];
		$number   = absint( $instance['number'] );
		$size     = $instance['size'];
		$target   = $instance['target'];
		$link     = $instance['link'];
		?>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'zobo' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></label></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of photos', 'zobo' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" /></label></p>		
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>"><?php esc_html_e( 'Photo size', 'zobo' ); ?>:</label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'size' ) ); ?>" class="widefat">
				<option value="thumbnail" <?php selected( 'thumbnail', $size ); ?>><?php esc_html_e( '150x150', 'zobo' ); ?></option>
				<option value="low_resolution" <?php selected( 'low_resolution', $size ); ?>><?php esc_html_e( '320x320', 'zobo' ); ?></option>
				<option value="standard_resolution" <?php selected( 'standard_resolution', $size ); ?>><?php esc_html_e( '640x640', 'zobo' ); ?></option>
			</select>
		</p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>"><?php esc_html_e( 'Open links in', 'zobo' ); ?>:</label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'target' ) ); ?>" class="widefat">
				<option value="_self" <?php selected( '_self', $target ); ?>><?php esc_html_e( 'Current window (_self)', 'zobo' ); ?></option>
				<option value="_blank" <?php selected( '_blank', $target ); ?>><?php esc_html_e( 'New window (_blank)', 'zobo' ); ?></option>
			</select>
		</p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>"><?php esc_html_e( 'Link text', 'zobo' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'link' ) ); ?>" type="text" value="<?php echo esc_attr( $link ); ?>" /></label></p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = ! absint( $new_instance['number'] ) ? 6 : $new_instance['number'];
		$instance['size'] = strip_tags( $new_instance['size'] );
		$instance['target'] = strip_tags( $new_instance['target'] );
		$instance['link'] = strip_tags( $new_instance['link'] );
		return $instance;
	}
}

add_action('widgets_init', 'aztheme_instagram_init');
function aztheme_instagram_init() {
    register_widget('AZTheme_Instagram_Feed');
}
