<?php
add_action('admin_enqueue_scripts', 'zobo_widget_script');
function zobo_widget_script() {
    wp_enqueue_media();
    wp_enqueue_script('zobo_widget', get_template_directory_uri() . '/assets/js/widget.js', false, '1.0', true);
}
class Zobo_About_Me extends WP_Widget
{
    public function __construct()
    {
        $widget_ops = array('classname'   => 'zobo_categories_widget');        
        parent::__construct('zobo_about_me', 'AZTheme: About Me', $widget_ops);
    }
    
    public function widget($args, $instance)
    {
        extract($args, EXTR_SKIP);
        echo wp_kses_post($before_widget); ?>    	
    	<div class="zobo-widget-content zobo-about-me">
            <?php if ( isset($instance['image_uri']) && $instance['image_uri'] != '' ) { ?>
            <div class="img-ab"><img src="<?php echo esc_url($instance['image_uri']); ?>" alt="<?php echo esc_attr__('About image', 'zobo'); ?>"/></div>
            <?php } ?>
            <div class="about-info">                
                <?php if ( isset($instance['title']) && $instance['title'] != '' ) { ?>
                <h4 class="widget-title"><?php echo esc_html($instance['title']); ?></h4>
                <?php } ?>
                <?php if ( isset($instance['short_desciption']) && $instance['short_desciption'] != '' ) { ?>
                <div class="about-text"><?php echo wp_kses_post($instance['short_desciption']); ?></div>
                <?php } ?>
                <?php if ( isset($instance['link']) && $instance['link'] != '' ) { ?>
                <a href="<?php echo esc_url($instance['link']); ?>" class="about-link az-button"><?php echo esc_html($instance['link_text']); ?></a>
                <?php } ?>
            </div>
    	</div><?php
        
        echo wp_kses_post($after_widget);
    }
    
    public function update( $new_instance, $old_instance )
    {
        $instance = $old_instance;
		$instance['title']              = strip_tags($new_instance['title']);
        $instance['short_desciption']   = strip_tags($new_instance['short_desciption']);
        $instance['image_uri']          = strip_tags($new_instance['image_uri']);
        $instance['link_text']          = strip_tags($new_instance['link_text']);
        $instance['link']               = $new_instance['link'];
		return $instance;
    }

    public function form( $instance )
    {
        $title              = empty($instance['title']) ? esc_html__('About Me', 'zobo') : $instance['title'];
        $short_desciption   = isset($instance['short_desciption']) ? $instance['short_desciption'] : null;
        $image_uri          = isset($instance['image_uri']) ? $instance['image_uri'] : null;
        $link_text          = isset($instance['link_text'] ) ? $instance['link_text'] : esc_html__('Read More', 'zobo');
        $link               = isset($instance['link'] ) ? $instance['link'] : '#'; ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name('title')); ?>"><?php echo esc_html__('Title', 'zobo'); ?>:</label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('image_uri')); ?>">Image:</label><br />
            <img class="custom_media_image widefat" src="<?php echo esc_url($image_uri); ?>" style="margin:0;padding:0;max-width:100px;float:left;display:inline-block" />
            <input type="text" class="widefat custom_media_url" name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" id="<?php echo esc_attr($this->get_field_id('image_uri')); ?>" value="<?php echo esc_url($image_uri); ?>" style="margin-top:5px;"/>
            <input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" value="<?php echo esc_html__('Upload Image', 'zobo'); ?>" style="margin-top:5px;" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name('short_desciption')); ?>"><?php esc_html_e('About You', 'zobo'); ?>:</label>
            <textarea rows="8" class="widefat" id="<?php echo esc_attr($this->get_field_id('short_desciption')); ?>" name="<?php echo esc_attr($this->get_field_name('short_desciption')); ?>"><?php echo esc_attr($short_desciption); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name('link_text')); ?>"><?php esc_html_e('Link Text', 'zobo'); ?>:</label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('link_text')); ?>" name="<?php echo esc_attr($this->get_field_name('link_text')); ?>" type="text" value="<?php echo esc_attr($link_text); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name('link')); ?>"><?php esc_html_e('Link', 'zobo'); ?>:</label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('link')); ?>" name="<?php echo esc_attr($this->get_field_name('link')); ?>" type="text" value="<?php echo esc_url($link); ?>" />
        </p>
    <?php
    }
}

function zobo_about_me_widget_init() {
    register_widget( 'Zobo_About_Me' );
}
add_action( 'widgets_init', 'zobo_about_me_widget_init' );
