<?php
    $catid = get_theme_mod('zobo_featured_posts_catid');
	$ids = get_theme_mod('zobo_featured_posts_ids');
	$showposts = get_theme_mod('zobo_featured_posts_limit');
	
	if ($ids) {
		$ids = explode(',', $ids);
		$args = array( 'showposts' => $showposts, 'post_type' => array('post', 'page'), 'post__in' => $featured_posts, 'orderby' => 'post__in' );
	} else {
		$args = array( 'cat' => $catid, 'showposts' => $showposts );
	}

	$loop = new WP_Query($args);    
    if ( $loop->have_posts() ) { ?>
    <div class="featured-posts-slider">
        <div class="owl-carousel" data-loop="true" data-autoplay="true" data-items="1" data-dots="true" data-nav="false">
            <?php while( $loop->have_posts() ) { ?>
                <?php $loop->the_post(); ?>
                <?php $featured_image = zobo_resize_image( get_post_thumbnail_id(), null, 1010, 700, true, true ); ?>
                <div class="item-post-feature d-md-table">
                    <div class="post-image d-md-table-cell">
                        <div class="bg-img" style="background-image: url('<?php echo esc_url($featured_image['url']);?>');" ></div>
                    </div>
                    <div class="post-info  d-md-table-cell">
                        <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php get_template_part('template-parts/post', 'meta'); ?>
                        <div class="post-excerpt"><?php the_excerpt(); ?></div>
                        <a class="readmore az-button" href="<?php the_permalink(); ?>"><?php echo esc_html__('Read on', 'zobo'); ?></a>
                    </div>
                </div>
            <?php } ?>
        </div>   
    </div><?php
    }
    wp_reset_postdata();
