<?php
    get_header();    
    if ( have_posts() ) {
        while ( have_posts() ) {
            the_post();
            $featured_image = null;
            if ( has_post_thumbnail() ) {
                $featured_image = zobo_resize_image( get_post_thumbnail_id(), null, 1530, 700, true, true );
                $featured_image = $featured_image['url'];
            } ?>
        <div class="main-contaier">
            <div class="zobo-single-post">
                <div class="container">
                    <?php if ( $featured_image ) { ?>                        
                    <div class="page-image">
                        <img src="<?php echo esc_url($featured_image); ?>" alt="<?php echo esc_attr__('Featured Image', 'zobo'); ?>"/>
                    </div>
                    <?php } ?>
                    <div class="page-content">
                        <div class="row justify-content-md-center">
                            <?php $page_class = get_theme_mod( 'zobo_page_sidebar' ) ? 'col-md-8 col-xl-9' : 'col-md-11 col-lg-10'; ?>
                            <article <?php post_class($page_class); ?>>
                                <?php if ( get_the_title() ) : ?>
                                    <h1 class="page-title"><?php the_title(); ?></h1>
                                <?php endif; ?>
                                <div class="page-excerpt">
                                    <?php the_content(); ?>
                                    <?php wp_link_pages(array('before'=>'<p class="page-nav">' . esc_html__( 'Pages:', 'zobo' ), 'after' =>'</p>')); ?>
                                </div>
                                <?php comments_template( '', true );  ?>
                            </article>
                            <?php if ( get_theme_mod( 'zobo_page_sidebar' ) ) { ?>
                            <div class="col-md-4 col-xl-3">
                                <?php if ( is_active_sidebar('page-sidebar') ) { ?>
                                <aside id="sidebar" class="sidebar">
                                	<?php dynamic_sidebar('page-sidebar'); ?>
                                </aside>
                                <?php } ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div><?php
        }
    }
	get_footer();
	