<?php
class Zobo_Categories_Images extends WP_Widget
{
    public function __construct()
    {
        $widget_ops = array(
            'classname'   => 'zobo_categories_widget',
            'description' => esc_html__('A list of categories.', 'zobo')
        );
        
        parent::__construct( 'zobo_categories_images', 'Zobo: Categories Images', $widget_ops );
    }
    
    public function widget($args, $instance)
    {
        extract($args, EXTR_SKIP);
        echo wp_kses_post($before_widget);
        $title          = ( empty($instance['title']) || !isset($instance['title']) ) ? 'Categories' : $instance['title'];
        $limit          = ( !isset($instance['limit']) || (int)$instance['limit'] < 1 ) ? 3 : (int)$instance['limit'];
        $hide_empty     = isset( $instance['hide_empty'] ) ? '1' : '0';
        $parent         = isset( $instance['parent'] ) ? 0 : '';
        $order          = isset( $instance['order'] ) ? $instance['order'] : 'ASC';
        $orderby        = isset( $instance['orderby'] ) ? $instance['orderby'] : 'name';
        
        $args = array(
          'orderby'     => $orderby,  
          'order'       => $order,
          'parent'      => $parent,
          'number'      => $limit,
          'hide_empty'  => $hide_empty
        );
        
        $categories = get_categories($args);

        if ( !empty($categories) ) : ?>
    	<h4 class="widget-title"><?php echo esc_attr($title); ?></h4>
    	<div class="zobo-widget-content zobo-categories-image">
    		<ul>
            <?php foreach ($categories as $cat) :                      
                ?>
                <?php if ( function_exists('z_taxonomy_image_url') ) : ?>
    			<li class="category-item" style="background-image: url('<?php echo esc_url(z_taxonomy_image_url($cat->term_id)); ?>');">
    				<div class="over-bg">
                        <a href="<?php echo get_category_link($cat->term_id); ?>">
                            <span class="name"><?php echo esc_attr($cat->name); ?></span>
                            <span class="count"><?php echo esc_attr($cat->count); ?></span>
                        </a>
                        
                    </div>
    			</li>
                <?php endif; ?>
            <?php endforeach; ?>
    		</ul>
    	</div><?php
        endif;
        echo wp_kses_post($after_widget);
    }
    
    public function update( $new_instance, $old_instance )
    {
        $updated_instance = $new_instance;
        return $updated_instance;
    }

    public function form( $instance )
    {
        $title              = empty($instance['title']) ? esc_html__('Categories Images', 'zobo') : $instance['title'];
        $limit              = ( !isset($instance['limit']) || (int)$instance['limit'] < 1 ) ? 3 : (int)$instance['limit'];
        $hide_empty         = isset( $instance['hide_empty'] ) ? true : false;
        $parent             = isset( $instance['parent'] ) ? '0' : '';
        $order              = isset( $instance['order'] ) ? $instance['order'] : 'ASC';
        $orderby            = isset( $instance['orderby'] ) ? $instance['orderby'] : 'name';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name( 'title' )); ?>"><?php esc_html_e( 'Title:', 'zobo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name( 'limit' )); ?>"><?php esc_html_e( 'Limit:', 'zobo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'limit' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'limit' )); ?>" type="text" value="<?php echo esc_attr( $limit ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name( 'hide_empty' )); ?>"><?php esc_html_e( 'Hide Empty', 'zobo' ); ?></label>
            <input class="widefat" <?php if ( 1 == $hide_empty ) : ?>checked=""<?php endif; ?> id="<?php echo esc_attr($this->get_field_id( 'hide_empty' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hide_empty' )); ?>" type="checkbox" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name( 'parent' )); ?>"><?php esc_html_e( 'Parent', 'zobo' ); ?></label>
            <input class="widefat" <?php if ( '0' == $parent ) : ?>checked=""<?php endif; ?> id="<?php echo esc_attr($this->get_field_id( 'parent' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'parent' )); ?>" type="checkbox" />
            <i>Get only top level categories</i>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>"><?php esc_html_e( 'Order By', 'zobo' ); ?></label>
            <select class='widefat' id="<?php echo esc_attr($this->get_field_id('orderby')); ?>" name="<?php echo esc_attr($this->get_field_name('orderby')); ?>">
            	<option value='term_id'<?php echo esc_attr( ($orderby == 'term_id') ? 'selected' : '' ) ; ?>><?php esc_html_e('ID', 'zobo'); ?></option>
                <option value='name'<?php echo esc_attr( ($orderby == 'name') ? 'selected' : '' ); ?>><?php esc_html_e('Name', 'zobo'); ?></option>
                <option value='count'<?php echo esc_attr( ($orderby == 'count') ? 'selected' : '' ); ?>><?php esc_html_e('Count', 'zobo'); ?></option>
            </select>
            <i><?php esc_html_e('Sort categories alphabetically, by unique Category ID, or by the count of posts in that Category', 'zobo'); ?></i>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_name( 'order' )); ?>"><?php esc_html_e( 'Order', 'zobo' ); ?></label>
            <select class='widefat' id="<?php echo esc_attr($this->get_field_id('order')); ?>" name="<?php echo esc_attr($this->get_field_name('order')); ?>">
            	<option value='ASC'<?php echo esc_attr( ($order == 'ASC') ? ' selected="selected"' : '' ); ?>><?php esc_html_e('ASC', 'zobo'); ?></option>
                <option value='DESC'<?php echo esc_attr( ($order == 'DESC') ? ' selected="selected"' : '' ); ?>><?php esc_html_e('DESC', 'zobo'); ?></option>
            </select>
            <i><?php esc_html_e('Sort order for categories (either ascending or descending). The default is ascending', 'zobo'); ?></i>
        </p>
    <?php
    }
}

function zobo_categories_images_widget_init() {
    register_widget( 'Zobo_Categories_Images' );
}
add_action( 'widgets_init', 'zobo_categories_images_widget_init' );
